/**
 * Panel AI page scripts
 *
 * @version 1.0.0
 * @since 9.1.0
 */

window.et_panel = window.et_panel || {};
!function($) {
    $(document).ready(function ($) {
        var global_configuration = {
            popup: $('.et_panel-popup'),
            closePopupIcon: '<span class="et_close-popup et-button-cancel et-button"><i class="et-admin-icon et-delete"></i></span>',
            spinner: '<div class="et-loader ">\
					<svg class="loader-circular" viewBox="25 25 50 50">\
					<circle class="loader-path" cx="50" cy="50" r="12" fill="none" stroke-width="2" stroke-miterlimit="10"></circle>\
					</svg>\
				</div>',
        };

        var global_configuration_functions = {
            openPopup: function () {
                $('body').addClass('et_panel-popup-on');
                global_configuration.popup.html(global_configuration.spinner);
            },
            closePopup: function (response, closeIcon, refresh) {
                global_configuration.popup.html('').addClass('loading');

                if ((typeof closeIcon == "boolean" && closeIcon == true) || typeof closeIcon == "undefined")
                    global_configuration.popup.prepend(global_configuration.closePopupIcon);

                global_configuration.popup.append(response.icon);
                global_configuration.popup.append(response.msg);
                global_configuration.popup.addClass('active').removeClass('loading');

                if (typeof refresh == "boolean" && refresh == true)
                    window.location = window.location.href;
            }
        };

        var et_AI = {
            instagram_save_network_options: function(_this,e) {
                e.preventDefault();
                _this.parents('.etheme-div').find('.etheme-network-save-info').addClass('hidden');
                _this.closest('.etheme-div').addClass('processing');

                global_configuration_functions.openPopup();

                var data = {
                    action: 'etheme_update_network',
                    helper: 'instagram',
                    form: _this.closest('form').serializeArray()
                };
                $.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: data,
                    success: function (data) {
                        global_configuration_functions.closePopup(data);
                    },
                    error: function () {
                        alert('Error while deleting');
                    },
                    complete: function () {
                        _this.closest('.etheme-div').removeClass('processing');
                    }
                });
            },
        };

        window.et_panel = Object.assign(window.et_panel,et_AI);

        var et_AI_actions = {
            '1': {
                selector: '.etheme-network-save',
                type: 'click',
                callback : et_panel.instagram_save_network_options
            },
        }

        $.each(et_AI_actions, function (i, t) {
            if (t.type == 'ready'){
                $(document).ready(function (e) {
                    t.callback($(this),e);
                });
            } else {
                $(t.selector).on(t.type,function (e){
                    t.callback($(this),e);
                });
            }
        });
    });
}(jQuery,window.et_panel);