<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title><?php echo get_bloginfo( 'name', 'display' ); ?></title>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--[if !mso]>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <![endif]-->

    <!--[if (mso 16)]>
    <style type="text/css">
        a {
            text-decoration: none;
        }

        span {
            vertical-align: middle;
        }
    </style>
    <![endif]-->

    <style type="text/css">
        #outlook a {
            padding: 0;
        }

        a {
            text-decoration: none;
        }

        body {
            margin: 0;
            padding: 0;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        table, td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
            vertical-align: middle;
        }

        p {
            display: block;
            margin: 0;
            line-height: inherit;
            font-size: inherit;
        }

        div.viwec-responsive {
            display: inline-block;
        }
    </style>

    <!--[if mso]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG/>
        </o:OfficeDocumentSettings>
    </xml>
    <![endif]-->

    <!--[if lte mso 11]>
    <style type="text/css">
        .viwec-responsive {
            width: 100% !important;
        }
    </style>
    <![endif]-->

    <!--[if mso | IE]>
    <style type="text/css">
        .viwec-responsive {
            width: 100% !important;
        }
    </style>
    <![endif]-->

    <!--[if !mso]><!-->
    <link href="https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700" rel="stylesheet" type="text/css">
    <style type="text/css">
        @import url(https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700);
    </style>
    <!--<![endif]-->

    <style type="text/css">

        @media only screen and (min-width: 380px) {
            a {
                text-decoration: none;
            }

            td {
                overflow: hidden;
            }

            div.viwec-responsive {
                display: inline-block;
            }

        }

        @media only screen and (max-width: 380px) {
            a {
                text-decoration: none;
            }

            td {
                overflow: hidden;
            }

            .viwec-responsive {
                width: 100% !important;
            }

            .viwec-responsive-padding {
                padding: 0 !important;
            }

            .viwec-mobile-hidden {
                display: none !important;
            }

            .viwec-responsive-center {
                text-align: center !important;
            }

            #wrapper {
                min-width: 380px !important;
            }

            .viwec-mobile-50 {
                width: 50% !important;
            }

            .viwec-mobile-button-padding {
                padding: 10px 20px !important;
            }
        }

    </style>


</head>

<body <?php echo is_rtl() ? 'rightmargin' : 'leftmargin'; ?>="0" marginwidth="0" topmargin="0" marginheight="0" offset="0">
<div id="wrapper" dir="<?php echo is_rtl() ? 'rtl' : 'ltr'; ?>"
     style="min-width: 620px; width: 100%;box-sizing:border-box;padding:20px 0;<?php echo esc_attr( $bg_style ); ?>">
    <table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" style="font-size: 15px; ">
        <tbody>
        <tr>
            <td align="center" valign="top" id="body_content" style="<?php echo esc_attr( $bg_style ); ?>background-size:cover;">
